'use strict';

/* --------------------------------------------------------------
 configuration.js 2016-12-01
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2016 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

jse.libs.configuration = jse.libs.configuration || {};

/**
 * ## Configurations Library
 *
 * This library makes it possible to receive shop configuration values.
 *
 * @module JSE/Libs/datatable
 * @exports jse.libs.datatable
 */
(function (exports) {
    'use strict';

    /**
     * @type {String}
     */

    var pageToken = jse.core.config.get('pageToken');

    /**
     * @type {String}
     */
    var baseUrl = jse.core.config.get('appUrl') + '/shop.php?do=JsConfiguration';

    /**
     * Get the configuration value by the provided key.
     *
     * @param key Configuration key.
     *
     * @returns {Promise} The promise will be resolve with the configuration value.
     */
    exports.get = function (key) {
        return new Promise(function (resolve, reject) {
            var url = baseUrl + '/Get';
            $.ajax({ url: url, data: { key: key, pageToken: pageToken } }).done(function (response) {
                return resolve(response);
            }).fail(function (error) {
                return reject(error);
            });
        });
    };
})(jse.libs.configuration);
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
